import processing.pdf.*;

int tileW = 100;
int tileH = 100;

int offsetX = (tileW/2) * -1;
int offsetY = (tileH/2) * -1;

float[] oddAngles = {0,270};
float[] evenAngles = { 90, 180 };

int evenAnglesIdx = 0;
int oddAnglesIdx = 0;

float rotationDeg = 180;

int rowCount = 0;

void setup() {
  size(1000, 1000);
  beginRecord(PDF, "Yellow_Hib.pdf");
  background(0);
  smooth();
}

void draw() {
  for (int j = offsetY; j <= height; j += tileH) {
    rowCount++;
    for (int i = offsetX; i < width; i+=tileW) {

      drawTile(i, j, rotationDeg);

      //float randNum = random(2);
      //if (randNum < 1) {
      //  rotationDeg = 0;
      //} else {
      //  rotationDeg = 90;
      //}
      
      //rotationDeg = rotationDeg + 90;
      
      if(rowCount % 2 == 0){
         rotationDeg = getNextEvenAngle(); 
      }else{
        rotationDeg = getNextOddAngle(); 
      }
     
      
    }
  }
  endRecord();
  noLoop();
}

void drawTile(int x, int y, float deg) {
  pushMatrix();
  translate(x, y);
  rotate(radians(deg));
  translate(offsetX, offsetY);






  {

    noStroke();

    fill(#008B01,150);
    triangle(50, 0, 100, 0, 100, 100);
    triangle(0, 50, 0, 100, 100, 100);

    fill(#29D62A);
    quad(25, 25, 80, 50, 100, 100, 50, 80);

    fill(#FFF305);
    ellipse(100, 50, 30, 75);
    ellipse(50, 100, 75, 30);

    stroke(#67090B);
    line(75, 75, 100, 100);
  }

  strokeWeight(4);
  stroke(#FFC505);
  line(200, 200, 60, 0);
  line(200, 200, 0, 60);

  popMatrix();
}

float getNextEvenAngle() {
  if (evenAnglesIdx >= evenAngles.length - 1) {
    evenAnglesIdx = 0;
  } else {
    evenAnglesIdx += 1;
  }
  return oddAngles[evenAnglesIdx];
}

float getNextOddAngle() {
  if (oddAnglesIdx >= oddAngles.length - 1) {
    oddAnglesIdx = 0;
  } else {
    oddAnglesIdx += 1;
  }
  return evenAngles[oddAnglesIdx];
}